<?php
namespace App\Http\Controllers\Painel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repository\Painel\ConfigRepository;
use App\Repository\Painel\userRepository;
use App\User;
use Auth;

class AdminController extends Controller
{

    private $ConfigRepository;
    private $UserRepository;
    public  $req;
    public  $uri;
    public function __construct(ConfigRepository $ConfigRepository, UserRepository $UserRepository, Request $req)
    {
      $this->ConfigRepository = $ConfigRepository;
      $this->UserRepository = $UserRepository;
      $uri = $req->route()->uri();
      $uri = explode('/', $uri);
      if (count($uri) > 1){
          if($uri[1] == 'config'){
            $this->uri = 'Configurações';
          }else{
            $this->uri = ucfirst($uri[1]);
          }
      }else{
        $this->uri = '';
      }
    }

   public function login(){
   	if (Auth::check() === false) {
	   	return view('login');
	  }else{
	  	return redirect()->route('admin.dashboard');
	  }
   }
  public function visitor(){

    if (Auth::check() === true) {
      return $this->ConfigRepository->visitor($this->uri);
      //return view('admin.dashboard');
    }else{
      return redirect()->route('login');
    }
  }

   public function show(){
   	if (Auth::check() === true) {
         return $this->ConfigRepository->show($this->uri);
	   	//return view('admin.dashboard');
   	}else{
   		return redirect()->route('login');
   	}
   }

   public function entrar(Request $req){
   		$dados = $req->all();
         //dd($dados);
   		if (!filter_var($req->email, FILTER_VALIDATE_EMAIL) ) {
   			return redirect()->back()->withErrors(['E-mail informado não e valido!']);
   		}
   		//dd($dados);
   		$credenciais =[
				'email'=>$dados['email'],
				'password'=>$dados['senha']
			];
   		if (Auth::attempt($credenciais)) {
   			return redirect()->route('admin.dashboard');
   		}

   		return redirect()->back()->withErrors(['Os dados não conferem!']);

   }

   public function sair(){
   	Auth::logout();
   	return redirect()->route('admin.login');
   }

  public function addUser(Request $req)
  {
    return $this->UserRepository->addUser($req);
//    $dados = [
//      'name' => "kopicz",
//      'email' => "kopicz@techsoft.net.br",
//      'password' => bcrypt("kopicz"),
//    ];
//
//    if (User::where('email', '=', $dados['email'])->count()) {
//      $usuario = User::where('email', '=', $dados['email'])->first();
//      $usuario->update($dados);
//      echo 'up ok';
//    } else {
//      User::create($dados);
//      echo 'add ok';
//    }
  }

  public function showUser(){
    if (Auth::check() === true) {
      return $this->UserRepository->showUser($this->uri);
      //return view('admin.dashboard');
    }else{
      return redirect()->route('login');
    }
  }

  public function updateUser(Request $req){
    return $this->UserRepository->updateUser($req);
  }
  public function deleteUser($id){
    return $this->UserRepository->deleteUser($id);
  }

}
