<?php
namespace App\Http\Controllers\Painel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repository\Painel\BannerRepository;

class BannerController extends Controller
{
  /**
   * Display a listing of the resource.
   *
   * @return \Illuminate\Http\Response
   */
  public  $uri;
  /**
   * @var BannerRepository
   */
  private $BannerRepository;

  public function __construct(BannerRepository $BannerRepository, Request $req)
  {
    $this->BannerRepository = $BannerRepository;
    $uri = $req->route()->uri();
    $uri = explode('/', $uri);
    if (count($uri) > 1){
      $this->uri = ucfirst($uri[1]);
    }else{
      $this->uri = '';
    }
  }

  public function show(){
    return $this->BannerRepository->show($this->uri);
  }

  public function addBanner(Request $req){
    return $this->BannerRepository->addBanner($req);
  }

  public function deleteBanner($id){
    return $this->BannerRepository->deleteBanner($id);
  }


}
