<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;

class Produto extends Model
{
  protected $connection = 'tenant';
  public $timestamps = false;
  protected $table = "produtos";
  protected $fillable = [
    "id" => "codigo",
    "codbarra1",
    "codbarra2",
    "codbarra3",
    "codauxili1",
    "codauxili2",
    "descricao",
    "descreduzi",
    "descdeta1",
    "descdeta2",
    "descdeta3",
    "descdeta4",
    "localiza",
    "subgrupo",
    "grupo",
    "departamen",
    "marca",
    "precovenda",
    "preco",
    "margem",
    "estoque",
    "estoquemin",
    "estoqueide",
    "estoquepen",
    "unidade",
    "diasvalid",
    "peso",
    "tipo",
    "dataalt",
    "agrupament",
    "fracionado",
    "customedio",
    "percomis",
    "naocomis",
    "fatorconv",
    "origem",
    "ncm",
    "icmsin",
    "icmsinrev",
    "icmsinind",
    "icmsinper1",
    "icmsinper2",
    "icms",
    "icmscn",
    "icmscr",
    "icmsindu",
    "icmsper1",
    "icmsper2",
    "piscof",
    "alipi",
    "credicms",
    "bcstret",
    "vlrstret",
    "ppb",
    "fabpropri",
    "recstant",
    "gradeprinc",
    "grade1",
    "grade2",
    "alstret",
    "imprvale",
    "marcapro",
    "exproeco",
    "precoeco",
    "estoqueeco",
    "dimeneco",
    "entfreeeco",
    "destproeco",
    "tamcompalm",
    "expsemest",
    "obsprod"

	];

	public function setprecoAttribute($value){
		$value = formataValor($value, 'false') ;
    dd('R$ '.number_format($value, 3, ',', '.'));
	}
}
