<?php
namespace App\Repository\Home;

use App\Http\Models\Config;

use App\Http\Models\Produto;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\DB;
use phpDocumentor\Reflection\Types\This;
use Illuminate\Database\Eloquent\Collection;

class CardRepository{
  public function show()  {
    $card =  json_decode(Cookie::get('itensCard'));
    $prods = collect(new Produto());
    $prodAux = new Collection();
    $totalPedido = 0;
    foreach ($card as $c => $item){
      $produtos = DB::connection('tenant')->table('produtos as P')
        ->leftJoin('products_images as I', 'P.codigo', '=', 'I.codigo')
        ->select( 'P.codigo','P.descricao','P.descdeta1','P.precovenda','P.estoqueeco',
          'P.precoeco','P.dimeneco','P.entfreeeco','P.destproeco','P.exproeco','P.obsprod',
          'I.caminho', 'I.seq')
      //, '"'.$item->qtde.'" as qtde')
        ->where('P.codigo','=',$item->codigo)
        ->get();
      foreach ($produtos as $p => $produto){
        $prodAux = [
          'codigo' => $produto->codigo,
          'descricao' => $produto->descricao,
          'descdeta1' => $produto->descdeta1,
          'precovenda' => $produto->precovenda,
          'estoqueeco' => $produto->estoqueeco,
          'precoeco' => $produto->precoeco,
          'dimeneco' => $produto->dimeneco,
          'entfreeeco' => $produto->entfreeeco,
          'destproeco' => $produto->destproeco,
          'exproeco' => $produto->exproeco,
          'caminho' => $produto->caminho,
          'seq' => $produto->seq,
          'obsprod' => $produto->obsprod,
          'qtde' => $item->qtde];
      }
      $prods = $prods->push($prodAux);
      $totalPedido = $totalPedido + ($produto->precovenda*$item->qtde);
    }
    $conf = Config::query()->get()->first();
    return view('layout_cardapio.cardapio_card',compact('conf', 'prods', 'totalPedido'));
  }
  public function setCookie($req) {
    $itens = null;
    $itens = json_decode(Cookie::get('itensCard'));
    //$itens = array(array('codigo' => $req->codigo,'desc'   => $req->descricao,'qtde'   =>5,));
    $lnew = false;
    if($itens == null){
      $itens = array(
        array(
          'codigo' => $req->codigo,
          'desc'   => $req->descricao,
          'img'   => $req->img,
          'qtde'   => $req->qtde,
        )
      );
    }else{
      foreach ($itens as $key => $item ) {
        $cod2 = '';
        $cod = $item->codigo;
        if($cod == $req->codigo){
          $itens[$key]->qtde = $item->qtde+1;
        }else{
          $lnew = true;
        }
      }
      if($lnew){
        $newItem = array(
          'codigo' => $req->codigo,
          'desc'   => $req->descricao,
          'img'   => $req->img,
          'qtde'   => $req->qtde,
        );
        array_push($itens,$newItem);
      }
    }
    Cookie::queue(Cookie::forever('itensCard',json_encode($itens), '80'));
    return redirect()->route('home.card');
  }

  public function removeItem($req){
    $itens = null;
    $itens = Cookie::get('itensCard');
    $lnew = false;
    if($itens == null){
      return route('home.home');
    }else{
      foreach ($itens as $key => $item ) {
        $cod2 = '';
        $cod = $item['codigo'];
        if($cod == $req->codigo){
          unset($itens[$key]);
        }
      }
      if($lnew){
        $newItem = array(
          'codigo' => "666",
          'desc' => "666",
          'qtde' => "666"
        );
        array_push($itens,$newItem);
      }
    }
    Cookie::queue('itensCard',json_encode($itens), '80');
    return Cookie::get('itensCard');
  }
  public function cookieMata() {
    Cookie::queue(Cookie::forget('itensCard'));
    return redirect()->route('home.card');
  }
}
