<?php
namespace App\Repository\Home;

use App\Http\Models\Config;
use App\Http\Models\Banner;
use App\Http\Models\Grupopro;
use App\Http\Models\Produto;
use App\Http\Models\Visitor;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Cache;
use Illuminate\Support\Facades\Session;


class HomeRepository{
  public function __construct(ProductsRepository $ProductsRepository){
    $this->ProductsRepository = $ProductsRepository;
  }
  public function acesso(){
    $dia = date('Ymd');
    if (!Cache::has('key')){
      Cache::put('key', $_SERVER['REMOTE_ADDR'], now()->addMinutes(30));
      $dados = Visitor::query()->where('data',$dia );
      if ($dados->exists()){ //update
        $id = $dados->first('id')->id;
        $dados = Visitor::find($id);
        $dados->visitas++;
        $dados->save();
      }else{                     //insert
        $dados = new Visitor;
        $dados->data = $dia;
        $dados->visitas = '1';
        $dados->save();
      }
    }
  }

  public function guestAll(){
    $typeLayout = session('TypeLayout');
    $conf = Config::query()->get()->first();
    $banners = Banner::query()->where('tipo','b' )->get();//toSql para ver o select
    $fotosEmp = Banner::query()->where('tipo','e' )->get();//toSql para ver o select
    $grupos    = Grupopro::query()->where('exibeapp','1' )->get();//toSql para ver o select
    $produtos = $this->ProductsRepository->ListProducts($typeLayout);

    if($typeLayout == 'I'){
      return view('institucional',compact('conf', 'banners', 'fotosEmp', 'produtos'));
    }elseif($typeLayout == 'C'){
      return view('cardapio',compact('conf', 'banners', 'fotosEmp', 'grupos' ,'produtos'));
    }elseif($typeLayout == 'E'){
      return view('ecommerce',compact('conf', 'banners', 'fotosEmp', 'produtos'));
    }
  }
  public  function  mail($req){
    //return new \App\Mail\newContato($req);
    //dd($req->emailSend);
    Mail::to($req->emailSend,'TechSoft Sistemas')->send(new \App\Mail\newContato($req));
    //Mail::send(new \App\Mail\newContato($req));
    return $this->guestAll();

  }


  public function cadEmp()
  {
    $s = "INSERT INTO 'centralsite' (`cnpj`, `domain`, `host`, `dtbase`, `user`, `password`, `porta`, `tipo`, `ativo`) VALUES (";
    $s = $s . "'31510663000180',";
    $s = $s . "'digitalcentro.com.br',";
    $s = $s . "'0701061F11021E0A151A171A0E58060C1F471206C4',";
    $s = $s . "'0701061F11021E0A2F11000765',";
    $s = $s . "'0701061F11021E0A2F11000765',";
    $s = $s . "'47011202000E131A304653595933',";
    $s = $s . "'505B514000',";
    $s = $s . "'I',";
    $s = $s . "1";
    return $s;


  }
}
