<?php
namespace App\Repository\Home;
use App\Http\Models\Config;
use App\Http\Models\Grupopro;
use App\Http\Models\ImgProduto;
use App\Http\Models\Produto;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ProductsRepository{
  public function ListProducts($typeLayout){
    //$produtos = Produto::query()->paginate( 8);
    if ($typeLayout == 'C'){ //CARDAPIO

      //$produtos =collect();

      //$grupos    = Grupopro::query()->where('exibeapp','1' )->get();//toSql para ver o select
      //foreach ($grupos as $grupo) {
      $produtos = DB::connection('tenant')->table('produtos as P')
          ->leftJoin('products_images as I', 'P.codigo', '=', 'I.codigo')
          //->leftJoin('grupopro as G', 'P.grupo', '=', 'G.codigo')
          ->select('P.codigo', 'P.descricao', 'P.descdeta1', 'P.precovenda', 'P.estoqueeco',
            'P.precoeco', 'P.dimeneco', 'P.entfreeeco', 'P.destproeco', 'P.exproeco', 'P.grupo', 'P.obsprod',
            'I.caminho', 'I.seq')
          //, 'G.descricao as gdesc')
          ->where('exproeco', '=', '1')
          //->where('P.grupo', '=', $grupo->codigo)
          ->orderBy('P.codigo', 'desc')
          ->groupBy('P.codigo')
          ->get();

        //$produtos = $produtos->merge($prodaux->all());
      //}

    }elseif($typeLayout == 'I'){
      $produtos = DB::connection('tenant')->table('produtos as P')
        ->leftJoin('products_images as I', 'P.codigo', '=', 'I.codigo')
        ->select( 'P.codigo','P.descricao','P.descdeta1','P.precovenda','P.estoqueeco',
          'P.precoeco','P.dimeneco','P.entfreeeco','P.destproeco','P.exproeco',
          'I.caminho', 'I.seq' )
        ->where('exproeco','=','1')
        ->orderBy('P.codigo','desc')
        ->groupBy('P.codigo')

        ->get();
    }elseif($typeLayout == 'E'){}

    return ($produtos);
  }
  public function FindProducts($slug){
    $conf = Config::query()->get()->first();
    $desc = Str::upper(Str::of($slug)->replace('-',' '));

    $produtos = Produto::query()
      ->where('descricao','=', $desc)
//      ->where('estoqueeco','>', 0)
      ->limit(1)
      ->get(['codigo', 'descricao','precovenda', 'estoqueeco', 'precoeco', 'dimeneco','entfreeeco', 'destproeco', 'exproeco', 'obsprod']);

    if(count($produtos) > 0){
      foreach ($produtos as $prod){
        $imagens = ImgProduto::select('codigo','seq','caminho',DB::raw("CONCAT(codigo,'-',seq) AS codseq,CONCAT('p') AS tipo"))->where('codigo', $prod->codigo)->orderBy('seq', 'ASC')->get();
      }
      $TypeLayout = session('TypeLayout');
      if($TypeLayout == 'C'){
        return view('layout_cardapio.cardapio_detail',compact('conf','produtos', 'imagens'));
      }elseif($TypeLayout == 'E'){
        return view('ecommerce_detail',compact('conf','produtos', 'imagens'));
      }
    }else{
      return view('404',compact('conf'));
    }
  }
}







//$produtos = DB::connection('tenant')
//            ->table('produtos as P')
//            ->leftJoin('grupopro as G','P.grupo','=','G.codigo')
//            ->leftJoin('products_images as I', 'P.codigo', '=', 'I.codigo')
//            ->select( 'P.codigo','P.descricao','P.descdeta1','P.precovenda','P.estoqueeco',
//              'P.precoeco','P.dimeneco','P.entfreeeco','P.destproeco','P.exproeco',
//              'I.caminho', 'I.seq', 'G.codigo as gprod')
//            ->where('G.exibeapp','=','1')
//            ->where('exproeco','=','1')
//            //->orderBy('P.codigo','desc')
//            ->groupBy('G.codigo', 'P.codigo')
////            ->Tosql();
//            ->get();
