<?php

namespace App\Repository\Painel;

use App\Http\Models\Categoria;

class CategoriaRepository
{
  public function show($uri)
  {
    $categorias = Categoria::query()->paginate(8);
    return view('painel.produtos.categorias.listCategorias', compact('categorias', 'uri'));
  }

  public function search($req, $uri)
  {
    $categorias = Categoria::query()->paginate(8);
    return view('painel.produtos.categorias.listCategorias', compact('categorias', 'uri'));
  }

  public function save($req)
  {
    $cod = soNumeros($req->codigo);
    $cat = Categoria::query()->where('codigo', '=', $cod)->get(['codigo']);
    if ($req->descricao <> '') {
      if ($cat->count() == 0) { //insere
        $cod = Categoria::query()->max('codigo') + 1;
        $cat = new Categoria();
        $cat->codigo = $cod;
        $cat->descricao = substr($req->descricao, 0, 30);
        $cat->save();
      } else { //edita
        Categoria::where('codigo', $cod)->update([
          'descricao' => substr($req->descricao, 0, 30),
        ]);
      }
      return redirect()->route('admin.categorias');
    } else {
      return redirect()->back()->withErrors(['Verifique a descricao da categoria']);
    }
  }

  public function add($uri)
  {
    $categoria = new Categoria;
    return view('painel.produtos.categorias.manCategoria', compact('categoria', 'uri'));
  }

  public function edit($id, $uri)
  {
    $categorias = Categoria::query()->where('codigo', $id)->get(['codigo', 'descricao']);
    return view('painel.produtos.categorias.manCategoria', compact('categorias', 'uri'));
  }

  public function delete($id)
  {
    $dados = Categoria::where('codigo', $id)->get();
    if ($dados) {
      Categoria::where('codigo', $id)->delete();
    } else {
      return redirect()->back()->withErrors(['Não foi possivel excluir este produto',
        'Verifique se o produto já não foi excluido']);
    }
    return redirect()->route('admin.categorias');
  }
}
