<?php

namespace App\Repository\Painel;

use App\Http\Models\Config;
use App\Http\Models\Banner;
use App\Http\Models\Visitor;
use Illuminate\Support\Facades\DB;
use Cache;
use File;

class ConfigRepository
{
  public function visitor($uri)
  {
    $dataD = date('Ymd');
    $dataW = date('Ymd', strtotime("-7 day"));
    $dataM = date('Ymd', strtotime("-30 day"));
    $dataY = date('Ymd', strtotime("-365 day"));
    //dd($dataD, $dataW, $dataM, $dataY);
    try {
      $visitor = DB::connection('tenant')->select('SELECT D.visitas as Dvisitas,
                                                                  W.visitas as Wvisitas,
                                                                  M.visitas as Mvisitas,
                                                                  Y.visitas as Yvisitas
                                                    FROM (SELECT SUM(visitas)as visitas FROM visitors where data = ?) D,
                                                    (SELECT SUM(visitas)as visitas FROM visitors where data BETWEEN ? and ?) W,
                                                    (SELECT SUM(visitas)as visitas FROM visitors where data BETWEEN ? and ?) M,
                                                    (SELECT SUM(visitas)as visitas FROM visitors where data BETWEEN ? and ?) Y',
        [$dataD,$dataW,$dataD,$dataM,$dataD,$dataY,$dataD]);
    } catch (Exception $e) {
      dd('Exceção capturada: ',  $e->getMessage(), "\n");
    }

//    foreach (visitor as $d){
//      echo $d->Dvisitas;
//    }
//dd($visitor);

    //$visitor = Visitor::query()->get()->first();
    return view('painel.index',compact('visitor', 'uri'));
}


  public function show($uri){
    $conf = Config::query()->get()->first();
    //$banners = Banner::query()->get();
    ;;$banners = Banner::query()->where('tipo','b' )->get();//toSql para ver o select
    $fotosEmp = Banner::query()->where('tipo','e' )->get();//toSql para ver o select
    //$produtos = Produto::query()->paginate(4);
    //dd($conf);
    //return view('admin . dashboard',compact('conf', 'banners', 'fotosEmp', 'produtos'));
    return view('painel.configuracoes',compact('conf','fotosEmp', 'uri'));
    //return view('admin . dashboard2',compact('conf', 'banners'));
    //return view('admin . oldLoging',compact('conf', 'banners'));//banners
  }

  public function update($req){
    //dd($req);
    $regras = [
      'email' => 'email | max:50'
    ];
    $mensagens = [
      'email . email' => 'Digite um endereço de email válido'
    ];

//    /$req->validate($regras, $mensagens);

    $dados = $req->all();
    $id = $dados['id'];

    if (isset($dados['excontato'])) {
      $dados['excontato'] = '1';
    }else{
      $dados['excontato'] = '0';
    }

    if (isset($dados['exformcont'])) {
      $dados['exformcont'] = '1';
    }else{
      $dados['exformcont'] = '0';
    }

    if (isset($dados['exmapa'])) {
      $dados['exmapa'] = '1';
    }else{
      $dados['exmapa'] = '0';
    }

    //if para tratamento de imagem
    if ($req->hasFile('logo')) {
      $logo = $req->file('logo');
      $num = rand(1111,9999);
      $dir = "img/logo";
      $ex = $logo->guessClientExtension();
      $nomelogo = "logo".$num.".".$ex;
      $logo-> move($dir,$nomelogo);
      $dados['logo'] = $dir."/".$nomelogo;
    }



    if(Config::find($id)){
      Config::find($id)->update($dados);
    }else{
      $config = new Config;
      $config->create($dados);
    }
    return redirect()->route('admin.config');
  }


}
