<?php
namespace App\Repository\Painel;
use App\Http\Models\Marcapro;

class MarcaproRepository{
  public function show($uri){
    $marcaspro = Marcapro::query()->paginate( 8);
    return view('painel.produtos.marcas.listMarcas',compact('marcaspro', 'uri'));
  }
  public function search($req,$uri){
    $marcaspro = Marcapro::query()->paginate(8);
    return view('painel.produtos.marcas.listMarcas', compact('marcaspro', 'uri'));
  }
  public function save($req)
  {
    $cod = soNumeros($req->codigo);
    $marca = Marcapro::query()->where('codigo', '=', $cod)->get(['codigo']);
    if ($req->descricao <> '') {
      if ($marca->count() == 0) { //insere
        $cod = Marcapro::query()->max('codigo') + 1;
        $marca = new Marcapro();
        $marca->codigo = $cod;
        $marca->descricao = substr($req->descricao, 0, 30);
        $marca->save();
      } else { //edita
        Marcapro::where('codigo', $cod)->update([
          'descricao' => substr($req->descricao, 0, 30),
        ]);
      }
      return redirect()->route('admin.marcas');
    } else {
      return redirect()->back()->withErrors(['Verifique a descricao da Marcapro']);
    }
  }

  public function add($uri){
    $marcaspro = new Marcapro;
    return view('painel.produtos.marcas.manMarca', compact('marcaspro', 'uri'));
  }
  public function edit($id, $uri){
    $marcaspro = Marcapro::query()->where('codigo', $id)->get(['codigo', 'descricao']);
    return view('painel.produtos.marcas.manMarca', compact('marcaspro', 'uri'));
  }
  public function delete($id)  {
    $dados = Marcapro::where('codigo', $id)->get();
    if ($dados) {
      Marcapro::where('codigo', $id)->delete();
    } else {
      return redirect()->back()->withErrors(['Não foi possivel excluir este produto',
        'Verifique se o produto já não foi excluido']);
    }
    return redirect()->route('admin.marcas');
  }

}
