<?php
namespace App\Repository\Painel;

use App\Http\Models\ImgProduto;
use App\Http\Models\Produto;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use File;
use mysql_xdevapi\Exception;
use phpDocumentor\Reflection\Types\False_;
use function Symfony\Component\String\u;

class ProdutoRepository{
  public function show($uri){
    $produtos = Produto::query()->paginate( 8);
    //dd($produtos);
    return view('painel.produtos.listProdutos',compact('produtos', 'uri'));
  }
  public function search($req,$uri){
    $search = $req->search;
    if  ($search){
      $produtos = Produto::query()->where('descricao','LIKE', '%' . $search . '%')->paginate( 8);
    } else{
      $produtos = Produto::query()->paginate( 8);
    }
    //return redirect()->route('admin.produtos', compact('produtos'));
    return view('painel.produtos.listProdutos',compact('produtos', 'uri'));
  }
///////////////////////////////////////////
  public function save($req){

    date_default_timezone_set('America/Sao_Paulo');
    $cod = soNumeros($req->codigo);
    if( $req->entfreeeco == 'on'){
      $entfreeeco = 1;
    }else{
      $entfreeeco = 0;
    }
    if($req->destproeco == 'on'){
      $destproeco = 1;
    }else{
      $destproeco = 0;
    }
    if($req->exproeco == 'on'){
      $exproeco = 1;
    }else{
      $exproeco = 0;
    }
    if($cod == ''){ //cadastro novo produto
      //dd('cadastro');
      $cod = Produto::query()->max('codigo')+1;
      $prod = new Produto;
      $prod->codigo = $cod;
      $prod->descricao  = substr($req->descricao, 0, 50);
      $prod->descdeta1 = $req->descrideta;
      $prod->estoqueeco = $req->estoqueeco;
      $prod->precoeco   = $req->precoeco;
      $prod->dimeneco   = 'L'.FormataValor($req->largura,8,2).'XA'.FormataValor($req->altura,8,2).'XP'.FormataValor($req->comprimento,8,2);
      $prod->entfreeeco = $entfreeeco;
      $prod->destproeco = $destproeco;
      $prod->exproeco   = $exproeco;
      $prod->save();
      if($req->file('caminho')){
        $lImg = $this->saveImage($cod, $req);
        if($lImg){
          return redirect()->route('admin.manProdutos',$cod);
        }else{
          return redirect()->back()->withErrors(['Não foi Salvar a imagem tente novamente']);
        }
      }else{
        return redirect()->route('admin.produtos');
      }
    }else{ //edita produto
      Produto::where('codigo',$cod)->update([
        'descricao'  =>  substr($req->descricao, 0, 50),
        'descdeta1' => $req->descrideta,
        'estoqueeco' => $req->estoqueeco,
        'precoeco'   => $req->precoeco,
        'dimeneco'   => 'L'.$req->largura.'XA'.$req->altura.'XP'.$req->comprimento,
        'entfreeeco' => $entfreeeco,
        'destproeco' =>$destproeco,
        'exproeco'   =>$exproeco,
        ]);
      if($req->file('caminho')){
        $lImg = $this->saveImage($cod,$req);
        if($lImg){
          return redirect()->route('admin.manProdutos',$cod);
        }else{
          return redirect()->back()->withErrors(['Não foi Salvar a imagem tente novamente']);
        }
      }else{
        return redirect()->route('admin.produtos');
      }
    }

  }
///////////////////////////////////////////

  public function saveImage($cod, $req){
    if($req->hasFile('caminho')){
      try{
        $logo = $req->file('caminho');
        $nomeProduto = date('His');
        $dir = "img/Produto";
        $ex = $logo->guessClientExtension();
        $nomeProduto = Str::slug($req->descricao).'-'.$nomeProduto.".".$ex;
        $logo->move($dir,$nomeProduto);
        $req->caminho = $dir."/".$nomeProduto;
        $seq = ImgProduto::where('codigo',soNumeros($cod))->max('seq')+1;
        $img = new ImgProduto;
        $img->codigo = soNumeros($cod);
        $img->seq = $seq;
        $img->caminho = $dir."/".$nomeProduto;
        $img->save();
        return True;
      }catch (Exception $e){
        return False;
      }
    }else{
      return False;
    }
  }




  public function add($uri){
    $produtos = new Produto;
    //dd($produtos);
    $imagens = new ImgProduto;
    //dd($imagens);
    return view('painel.produtos.manproduto',compact('produtos','imagens','uri'));
  }
  public function edit($id, $uri){
    $produtos = Produto::query()->where('codigo', $id)->get(['codigo', 'descricao','descdeta1','precovenda','estoqueeco',
    'precoeco', 'dimeneco','entfreeeco', 'destproeco', 'exproeco']);
    $imagens   = ImgProduto::select('codigo','seq','caminho',DB::raw("CONCAT(codigo,'-',seq) AS codseq,CONCAT('p') AS tipo"))->where('codigo', $id)->orderBy('seq', 'ASC')->get();
     return view('painel.produtos.manproduto',compact('produtos','imagens','uri'));
  }


  public function delete($id){
    $dados =  Produto::where('codigo',$id)->get();
    if($dados){
      Produto::where('codigo',$id)->delete();
      $dadosimg = ImgProduto::where('codigo',$id)->get();
      if(empty($dadosimg)){
        File::delete($dadosimg->caminho);
      }
    }else{
      return redirect()->back()->withErrors(['Não foi possivel excluir este produto',
                                             'Verifique se o produto já não foi excluido']);
    }
    return redirect()->route('admin.produtos');
  }
}
