<?php
namespace App\Repository\Painel;

use App\Http\Models\Visitor;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class getDadosGraphRepository{
  public function show()
  {
    $month_array = array();
    $graph = visitor::orderBy('data', 'ASC')->pluck('data');
    $graph = json_decode($graph);

    if (! empty($graph)){
      foreach ($graph as $g){
        $date = new \DateTime($g);
        $month_number = $date->format('mY');
        $month_name = $date->format('M Y');
        //echo $month_name.'-'.$month_number .'<br>';
        $month_array[$month_number] =   $month_name;
        //dd($month_array);
      }
    }
    //return $this->getVisitors('092020' );
    return $month_array;
  }
  function getVisitors($monthNumber){
    $month = substr($monthNumber, 0, 2);
    $year  = substr($monthNumber, 2);
    $countVisitors = visitor::whereMonth('data', $month)->whereYear('data', $year)->pluck('visitas');
    $countVisitors = $countVisitors->sum( );
    //dd($countVisitors);
    return $countVisitors;
  }
  function sumVisitorMonth(){
    $visitor_array = array();
    $month_array = $this->show();
    $month_array_name = array();
    if (! empty( $month_array )){
      foreach ($month_array as $month_number => $month_name){
         $visitor_count = $this->getVisitors($month_number);
         array_push($visitor_array, $visitor_count);
         array_push($month_array_name, $month_name);
      }
    }
    $max_number = max($visitor_array);
    $max_number = round(($max_number+10/2) / 10) *10;
    $monnth_graph = array(
        'months' => $month_array_name,
        'visitors' => $visitor_array,
        'maxNumber' => $max_number,

    );
    return $monnth_graph;
  }

}
