<?php
declare(strict_types=1);

namespace App\Tenant;
use App\Http\Models\Empresa;

class TenantManager{
    private $tenant;
    /**
     * @return Empresa
     */
    public function getTenant(): ?Empresa{
        return $this->tenant;
    }
    /**
     * @param Empresa $tenant
     */
    public function setTenant(?Empresa $tenant): void{
        $this->tenant = $tenant;
        $this->makeTenantConnection();
    }
    private function makeTenantConnection(){
        $clone = config('database.connections.dbtenant');
        $clone['host']     = $this->tenant->host;
        $clone['database'] = $this->tenant->dtbase;
        $clone['username'] = $this->tenant->user;
        $clone['password'] = $this->tenant->password;
        $clone['port']     = $this->tenant->porta;
       \Config::set('database.connections.tenant', $clone);//seta propriedades da nova conexao dentro de app/config...
        \DB::reconnect('tenant');//reconecta utilizando propridades passadas anteriormente
    }
    public function isTenantRequest(){
        return \Request::is('system/*') && \Request::route('prefix');
    }
}
