<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use app\Tenant\TenantManager;
use App\Http\Models\Config;

class CreateConfigsTable extends Migration
{
  /**
   * Run the migrations.
   *
   * @return void
   */
  public function up()
  {
    Schema::create('Configs', function($table){
      $table->increments('id');
      $table->string('logo',100)->nullable();
      $table->string('cormenu',6)->nullable();
      $table->string('corquemsomos',6)->nullable();
      $table->string('corcontato',6)->nullable();
      $table->string('corfooter',6)->nullable();
      $table->string('coremp',6)->nullable();
      $table->string('corprod',6)->nullable();
      $table->string('titulo',100)->nullable();
      $table->string('fone',16)->nullable();
      $table->string('fone2',16)->nullable();
      $table->string('whats',20)->nullable();
      $table->string('fantasia',50)->nullable();
      $table->string('razao',80)->nullable();
      $table->string('cpfcnpj',18)->nullable();
      $table->string('endereco',100)->nullable();
      $table->string('email',50)->nullable();
      $table->string('quemsomos',1000)->nullable();
      $table->string('face',100)->nullable();
      $table->string('insta',100)->nullable();
      $table->string('twitter',100)->nullable();
      $table->string('youtube',100)->nullable();
      $table->string('excontato',1)->nullable();
      $table->string('exformcont',1)->nullable();
      $table->string('exmapa',1)->nullable();
      $table->string('mapa',1000)->nullable();
      $table->string('msgwhats',200)->nullable();
      $table->integer('totalacesso')->nullable()->default(0);
      $table->timestamps();
    });
  }
  /**
   * Reverse the migrations.
   *
   * @return void
   */
  public function down()
  {
      Schema::dropIfExists('Configs');
  }
}
