<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProdutosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
  public function up(){
    Schema::create('produtos', function (Blueprint $table) {
      $table->increments('codigo');
      $table->string('codbarra1',14)->default('');
      $table->string('codbarra2',14)->default('');
      $table->string('codbarra3',14)->default('');
      $table->string('codauxili1',20)->default('');
      $table->string('codauxili2',20)->default('');
      $table->string('descricao',50)->default('');
      $table->string('descreduzi',25)->default('');
      $table->longText('descrideta');
      $table->string('descdeta1',50)->default('');
      $table->string('descdeta2',50)->default('');
      $table->string('descdeta3',50)->default('');
      $table->string('descdeta4',50)->default('');
      $table->string('localiza',25)->default('');
      $table->integer('subgrupo')->default(0);
      $table->integer('grupo')->default(0);
      $table->integer('departamen')->default(0);
      $table->integer('marca')->default(0);
      $table->double('precovenda', 12, 3)->default(0,000);
      $table->double('margem', 7, 2)->default(0,00);
      $table->double('estoque', 10,3)->default(0,000);
      $table->double('estoquemin', 10,3)->default(0,000);
      $table->double('estoqueide', 10,3)->default(0,000);
      $table->double('estoquepen', 10,3)->default(0,000);
      $table->string('unidade',2)->default('');
      $table->string('diasvalid',3)->default('');
      $table->double('peso', 7, 3)->default(0,000);
      $table->string('situacao',1)->default('');
      $table->string('tipo',1)->default('');
      $table->string('dataalt',14)->default('');
      $table->integer('agrupament')->default(0);
      $table->string('fracionado',1)->default('');
      $table->double('customedio', 12, 3)->default(0,000);
      $table->double('percomis', 5, 2)->default(0,00);
      $table->string('naocomis',1)->default('');
      $table->double('fatorconv', 12,3)->default(0,000);
      $table->string('origem',1)->default('');
      $table->string('ncm',8)->default('');
      $table->integer('icmsin')->default(0);
      $table->integer('icmsinrev')->default(0);
      $table->integer('icmsinind')->default(0);
      $table->integer('icmsinper1')->default(0);
      $table->integer('icmsinper2')->default(0);
      $table->integer('icms')->default(0);
      $table->integer('icmscn')->default(0);
      $table->integer('icmscr')->default(0);
      $table->integer('icmsindu')->default(0);
      $table->integer('icmsper1')->default(0);
      $table->integer('icmsper2')->default(0);
      $table->integer('piscof')->default(0);
      $table->integer('alipi')->default(0);
      $table->double('credicms', 12, 3)->default(0,000);
      $table->double('bcstret', 12, 3)->default(0,000);
      $table->double('vlrstret', 12, 3)->default(0,000);
      $table->bigInteger('ppb')->default(0);
      $table->string('fabpropri',1)->default('');
      $table->string('recstant',1)->default('');
      $table->integer('gradeprinc')->default(0);
      $table->integer('grade1')->default(0);
      $table->integer('grade2')->default(0);
      $table->double('alstret', 5, 2)->default(0,00);
      $table->string('imprvale',1)->default('');
      $table->string('marcapro',30)->default('');
      $table->string('exproeco',1)->default('');
      $table->double('precoeco', 12, 3)->default(0,000);
      $table->double('estoqueeco', 10, 3)->default(0,000);
      $table->string('dimeneco',30)->default('');
      $table->string('entfreeeco',1)->default('');
      $table->string('destproeco',1)->default('');
      $table->integer('tamcompalm')->default(0);
      $table->string('expsemest',1)->default('');
      $table->text('obsprod')->default('');
    });
  }
  /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('produtos');
    }
}
