<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubgrupo extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subgrupo', function (Blueprint $table) {
          $table->increments('codigo');
          $table->string('descricao',30)->nullable();
          $table->integer('grupo')->default(0);
          $table->double('margem', 7, 3)->default(0,000);
          $table->string('naocomis',1)->nullable();
          $table->double('percomis', 5, 2)->default(0,00);
          $table->double('descvista', 5, 2)->default(0,00);
          $table->string('ncm',1)->nullable();
          $table->integer('icms')->default(0);
          $table->string('dimeneco',30)->nullable();
          $table->string('exproeco',1)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subgrupo');
    }
}
