<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBairros extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bairros', function (Blueprint $table) {
          $table->integer('codigo') ->default(0);
          $table->string('bairro', 13, 3)->nullable();
          $table->string('cidade', 13, 3)->nullable();
          $table->string('taxa', 13, 3)->nullable();
          $table->double('valor', 13, 3)->default(0,000);
          $table->string('naofaz',1)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bairros');
    }
}
