$(function ( ) {
  function getcharts (){
    var urlPath =  window.location.hostname;
    var pathGraph = '/admin/get-graph';
    if (urlPath === '127.0.0.1'){
      urlPath = 'http://' + urlPath  + ':8000'+ pathGraph;
    }else if(urlPath === '192.168.237.86'){
      urlPath = 'http://' + urlPath  + ':8000'+ pathGraph;
    }else{
      urlPath = 'https://' + urlPath + pathGraph;
    }

    //alert(urlPath);
    var request = $.ajax( {
      method: 'GET',
      url: urlPath
  } );

    request.done( function ( response ) {
      //console.log( response );
      createcharts(response);

    });
  }

  'use strict'

  var ticksStyle = {
    fontColor: '#495057',
    fontStyle: 'bold'
  }
  var mode      = 'index'
  var intersect = true
  var $visitorsChart = $('#visitors-chart')
  getcharts();
  function createcharts(response) {

    var visitorsChart = new Chart($visitorsChart, {
      data: {
        labels: response.months,
        datasets: [
          {
            type: 'line',
            data: response.visitors,
            backgroundColor: "rgba(2,117,216,0.2)",
            borderColor: "rgba(2,117,216,1)",
            pointRadius: 5,
            pointBackgroundColor: "rgba(2,117,216,1)",
            pointBorderColor: "rgba(255,255,255,0.8)",
            pointHoverRadius: 5,
            pointHoverBackgroundColor: "rgba(2,117,216,1)",
            pointHitRadius: 20,
            pointBorderWidth: 2,
          }]
      },
      options: {
        maintainAspectRatio: false,
        tooltips: {
          mode: mode,
          intersect: intersect
        },
        hover: {
          mode: mode,
          intersect: intersect
        },
        legend: {
          display: false
        },
        scales: {
          yAxes: [{
            //display: false,
            gridLines: {
              // display: true,
              // //lineWidth: '4px',
              // color: 'rgba(0, 0, 0, .2)',
              // //zeroLineColor: 'transparent'
            },
            ticks: $.extend({
              beginAtZero: true,
              suggestedMax: response.maxNumber,
            }, ticksStyle)
          }],
          xAxes: [{
            display: true,
            gridLines: {
              //  display: false
            },
            ticks: ticksStyle
          }]
        }
      }
    })
  }
})
