@php
  $nbanners = $banners->count();
  $ngrupos = $grupos->count();
  $nprodutos = $produtos->count();
@endphp
<section class="text-white section1" id="carouselSection">
  @if ($nbanners > 0)
    <div id="carroselHome" class="carousel slide" data-ride="carousel">
      <ol class="carousel-indicators">
        @php
          $active = true;
          $nSlide = 0;
        @endphp
        @foreach ($banners as $banner)
          @if ($active == true)
            <li data-target="#carroselHome" data-slide-to="{{$nSlide}}" class="active">
          @else
            <li data-target="#carroselHome" data-slide-to="{{$nSlide}}">
          @endif
            </li>
          @php
            $active = true;
            $nSlide++;
          @endphp
        @endforeach
      </ol>
      <div class="carousel-inner">
        @php
          $active = true;
        @endphp
        @foreach ($banners as $banner)
          @if ($active == true)
            <div class="carousel-item active">
              @else
                <div class="carousel-item">
                  @endif
                  <img src="{{isset($banner->caminho) ? $banner->caminho : ''}}" class="d-block w-100  h-50"
                       alt="{{isset($banner->titulo) ? $banner->titulo : ''}}">
                </div>
                @php
                  $active = false;
//                @endphp
                @endforeach
            </div>
            <a class="carousel-control-prev" href="#carroselHome" role="button" data-slide="prev">
              <span class="carousel-control-prev-icon" aria-hidden="true"></span>
              <span class="sr-only">Previous</span>
            </a>
            <a class="carousel-control-next" href="#carroselHome" role="button" data-slide="next">
              <span class="carousel-control-next-icon" aria-hidden="true"></span>
              <span class="sr-only">Next</span>
            </a>
      </div>
    </div>
  @endif
</section>

<!-- section quem somos -->
  @if ($nbanners === 0)
    <section class="page-section text-white section1" id="quemsomos">
  @else
    <section class="page-section text-white " id="quemsomos">
  @endif
      <div class="container">
        <div class="row">
          <div class="col">
            <label class=" mb-0">Endereço: {{isset($conf->endereco) ? $conf->endereco : ''}}</label>
          </div>
          <div class="col text-end">
            <h5 class="">Loja: <b class="text-danger" style="text-shadow:
             -1px -1px 1px #000,
             -1px 1px 1px #000,
              1px -1px 1px #000,
              1px 1px 1px #000; ">Fechada</b></h5>
          </div>
        </div>
        <div class="row">
          <div class="col">
            <label class="">Pedido Minimo: R$ 20,00</label>
          </div>
          <div class="col text-end  ">
            <button class="btn btn-sm btn-danger" type="button" data-bs-toggle="modal" data-bs-target="#modalHorarios">Ver Horarios</button>
          </div>
          <!-- Modal Horarios-->
          <div class="modal fade" id="modalHorarios" tabindex="-1" role="dialog" aria-labelledby="modalHorarios" aria-hidden="true">
            <div class="modal-dialog" role="document">
              <div class="modal-content text-center">
                <div class="modal-header justify-content-center text-dark">
                  <h5 class="modal-title" id="modalHorarios">Horário de Funcionamento</h5>
                </div>
                <div class="modal-body">
                  <table class="table table-hover">
                    <tr><th scope="row">Segunda-Feira</th><td>Fechado</td></tr>
                    <tr><th scope="row">Terça-Feira</th><td>Fechado</td></tr>
                    <tr><th scope="row">Quarta-Feira</th><td>Fechado</td></tr>
                    <tr><th scope="row">Quinta-Feira</th><td>Fechado</td></tr>
                    <tr><th scope="row">Sexta-Feira</th><td>Fechado</td></tr>
                    <tr><th scope="row">Sabado</th><td>Fechado</td></tr>
                    <tr><th scope="row">Domingo</th><td>Fechado</td></tr>
                  </table>
                </div>
                <div class="modal-footer ">
                  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                </div>
              </div>
            </div>
          </div>
          <!-- Modal Horarios-->
        </div>
      </div>
    </section>
    <section class=""  id="produtos">
      <div class="container">
         <div class="input-group mb-2">
           <input type="text" class="form-control" placeholder="Pesquise por um item..." aria-label="" aria-describedby="">
           <button class="btn btn-outline-secondary" type="button" id="button-addon2"><i class="bi bi-search"></i></button>
         </div>

        <div class="form-group mb-2">
          <select class="form-control">
            <option>Categorias</option>
            @foreach($grupos as $grupo)
              <option>{{$grupo->descricao}}</option>
            @endforeach
          </select>
        </div>
      </div>

        <div class="container mt-2">
          <div class="card" id="container-categorias">
            <div class="card-header mb-2 " id="container-categorias">
              <h5 class="text-center">Promoçoes / Destaques</h5>
            </div>

              <div class="container text-center mb-2">
                <div class="row">
                  <div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
                    <div class="card">
                      <img src="https://mdbcdn.b-cdn.net/img/new/standard/nature/187.webp" class="card-img-top" alt="Peaks Against the Starry Sky">
                      <div class="card-body">
                        <h5 class="card-title">Card title</h5>
                        <p class="card-text">
                          Some quick example text to build on the card title and make up the bulk of
                          the card's content.
                        </p>
                        <a href="#!" class="btn btn-primary">Button</a>
                      </div>
                    </div>
                  </div>

                  <div class="col-lg-4 mb-4 mb-lg-0 d-none d-lg-block">
                    <div class="card">
                      <img src="https://mdbcdn.b-cdn.net/img/new/standard/nature/188.webp" class="card-img-top" alt="Bridge Over Water">
                      <div class="card-body">
                        <h5 class="card-title">Card title</h5>
                        <p class="card-text">
                          Some quick example text to build on the card title and make up the bulk of
                          the card's content.
                        </p>
                        <a href="#!" class="btn btn-primary">Button</a>
                      </div>
                    </div>
                  </div>

                  <div class="col-lg-4 mb-4 mb-lg-0 d-none d-lg-block">
                    <div class="card">
                      <img src="https://mdbcdn.b-cdn.net/img/new/standard/nature/189.webp" class="card-img-top" alt="Purbeck Heritage Coast">
                      <div class="card-body">
                        <h5 class="card-title">Card title</h5>
                        <p class="card-text">
                          Some quick example text to build on the card title and make up the bulk of
                          the card's content.
                        </p>
                        <a href="#!" class="btn btn-primary">Button</a>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
          </div>
        </div>

      @foreach($grupos as $grupo)

        <div class="container mt-2">
          <div class="card" id="container-categorias">
            <div class="card-header" id="container-categorias">
              <h5 class="text-center">{{$grupo->descricao}}</h5>
            </div>
            @foreach($produtos as $prod)
              @if($prod->grupo === $grupo->codigo)
                <a draggable="false" ondragstart="return false;"  id="linkaProd" href="{{route('home.detalhes', Str::of($prod->descricao)->slug('-'))}}">
                  <div class="card-body border p-1 mt-1 ml-1 mr-1" id="container-itens">

                      <div class="row">
                        <div class="col-4 col-sm-3 col-md-2 col-lg-2 col-xl-2 pl-3">
                          <div class="text-center pt-3 ">
  {{--                          <img class="img-thumbnail rounded mx-auto d-block" src="{{asset('img\Produto\pizza-123557.jpg')}}" alt="xpto">--}}
{{--                            <img class="img-thumbnail rounded" id="img-itens" src="{{asset('img\Produto\pizza-123557.jpg')}}" alt="xpto">--}}
                            <figure class="figure">
                              <img id="img-itens" src="{{asset('img\Produto\pizza-123557.jpg')}}" class="figure-img img-thumbnail img-fluid rounded">
                            </figure>
                          </div>
                        </div>
                        <div class=" col-8 col-sm-9 col-md-10 col-lg-10 col-xl-10">
                          <div class="row pt-3" >
                            <div class="col-sm">
                              <b>{{mb_convert_case($prod->descricao, MB_CASE_TITLE, "UTF-8")}}</b>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-sm">
                              <p class="font-italic text-justify">{{limita_caracteres(ucfirst(isset($prod->obsprod) ? $prod->obsprod : ''),100)}}</p>
                            </div>
                          </div>
                          <div class="row" style="margin-right: 20px;">
                            <div class="col text-end mt-3">
                              <h5>Preço: <b>{{isset($prod->precovenda) ? $prod->precovenda : ''}}</b></h5>
                            </div>
                          </div>
                        </div>
                      </div>

                  </div>
                </a>
              @endif
            @endforeach
          </div>
        </div>

      </div>
    @endforeach
    </section>
  <!-- section contato -->
  {{-- @endif --}}
    <section class="page-section" id="contato">
      <div class="container">
        <div class="row">
          <div class="col-lg-6 text-center">
            <h4 class="text-uppercase">Localização</h4>
            <iframe class="col-12" height="350" src="{{isset($conf->mapa) ? $conf->mapa : ''}}"
                    allowfullscreen="" tabindex="0"></iframe>
            <p class=" mb-0">{{isset($conf->endereco) ? $conf->endereco : ''}}</p>
          </div>
          @if($conf->email <> '' or $conf->email <> null)
            @include('layout_site._includes.contato')
          @endif
        </div>
      </div>
    </section>
