@php
  $nfotos = $imagens->count();
  $prod = $produtos->first();
  //dd($nfotos);

@endphp
<section class="section1" id="carouselSection">
  <br>
  <div class="container">
    <div class="card card-solid">
      <div class="row">
        <div class="col-md-6">
          <h3 class="d-inline-block d-sm-none m-3">{{$prod->descricao}}</h3>
          <div id="slide-photo" class="carousel slide" data-ride="carousel" align="center" data-interval="0">
            <!-- slides -->
            <div class="carousel-inner mt-2">
              @php
                $active = true;
              @endphp
              @foreach ($imagens as $image)
                @if ($active == true)
                  <div class="carousel-item active">
                    <img src="{{asset($image->caminho)}}" class="img-fluid">
                  </div>
                @else
                  <div class="carousel-item">
                    <img src="{{asset($image->caminho)}}" class="img-fluid">
                  </div>
                @endif
                @php
                  $active = false;
                @endphp
              @endforeach

            </div> <!-- Left right -->
            <a class="carousel-control-prev" href="#slide-photo" data-slide="prev"> <span class="carousel-control-prev-icon">
                </span>
            </a>
            <a class="carousel-control-next" href="#slide-photo" data-slide="next"> <span class="carousel-control-next-icon">
                </span>
            </a>
            <!-- Thumbnails -->
            <ol class="carousel-indicators list-inline">
              @php
                $active = true;
                $nSlide = 0;
              @endphp
              @foreach ($imagens as $image)
                @if ($active == true)
                  <li class="list-inline-item active ">
                    <a id="carousel-selector-0" class="selected" data-slide-to="{{$nSlide}}" data-target="#slide-photo">
                      <img src="{{asset($image->caminho)}}" class="img-fluid product-image-thumb" alt="Product Image">
                    </a>
                  </li>
                @else
                  <li class="list-inline-item">
                    <a id="carousel-selector-1" data-slide-to="{{$nSlide}}" data-target="#slide-photo">
                      <img src="{{asset($image->caminho)}}" class="img-fluid product-image-thumb" alt="Product Image">
                    </a>
                  </li>
                @endif
                @php
                  $active = false;
                  $nSlide++;
                @endphp
              @endforeach
            </ol>
          </div>
        </div>
        <div class="col-12 col-md-6">
          <h3 class="m-3">{{$prod->descricao}}</h3>
          <p class="text-justify m-3">{{strip_tags(substr($prod->obsprod, 0, 200))}}</p>

          <div class="bg-gray py-2 px-3 mt-4">
            <h2 class="mb-0">
              {{FormataValor($prod->precoeco,13,2)}}
            </h2>
            <h4 class="mt-0">
              <small>Parcelado: R$90.00 </small>
            </h4>
          </div>

          <div class="d-flex justify-content-center mt-4">
            <div class="btn btn-primary btn-lg">
              <i class="fas fa-cart-plus"></i>
              Adicionar ao Carinho
            </div>
            {{--              <div class="btn btn-default btn-lg btn-flat">--}}
            {{--                <i class="fas fa-heart fa-lg mr-2"></i>--}}
            {{--                Adicionar aos favoritos--}}
            {{--              </div>--}}
          </div>
        </div>

      </div>

    </div>
  </div>
  <br>
  <div class="container">
    <div class="card card-solid">
      <div class="container">
        <br>
        <div class="alert alert-dark" role="alert">
          Descrição do Produto
        </div>
        <div class="container">
          <div class="tab-pane fade show active" id="product-desc" role="tabpanel" aria-labelledby="product-desc-tab">
            @php echo $prod->obsprod @endphp
          </div>
        </div>
      </div>
    </div>
  </div>


  <br>
  <br>
  <br>

</section>





