@php
  $nProd = $produtos->count();
  //dd($nProd);
@endphp
@if ($nProd > 0)
<section class="page-section" id="produtos" >
  <div class="container">
    <h1 class="font-weight-light text-center mb-3 ">Produtos / Serviços</h1>
  </div>
  <div class="container text-center my-3">
    <div class="row mx-auto my-auto justify-content-center">
      <div id="recipeCarousel" class="carousel slide" data-bs-ride="carousel">
        <div class="carousel-inner" role="listbox">
            @php $active = true @endphp
          @foreach ($produtos as $prod)
            @if ($active)
              <div class="carousel-item active">
            @else
              <div class="carousel-item">
            @endif
                <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                  <div class="card">
                    <div class="container-fluid" style=" color: black; padding: 25px;border: 1px solid;">
                      <div class="row justify-content-center" style=" margin-bottom: 30px">
                        <img src="{{$prod->caminho}}" class="img-fluid  mx-auto d-block" alt="{{$prod->descricao}}"
                             style="height: 250px; padding: 10px"
                             data-bs-target="modal"  data-bs-slide-to="#modalProdShow{{$prod->codigo}}">
                      </div>
                      <div class="row justify-content-center" style="height: 100px">
                        <p>{{$prod->descricao}}</p>
                      </div>
                      <div class="row justify-content-center">
                        <button class="btn btn-outline-dark" data-bs-toggle="modal"  data-bs-target="#modalProdShow{{$prod->codigo}}">Detalhar</button>

                      </div>
                    </div>
                  </div>
                </div>
            @php $active = false @endphp
            @if ($active)
              </div>
            @else
              </div>
            @endif
          @endforeach

        </div>
        <a class="carousel-control-prev" href="#recipeCarousel" role="button" data-bs-slide="prev" style="width: 40px;background: black">
          <span class="carousel-control-prev-icon" aria-hidden="true" ></span>
          <span class="visually-hidden">Anterior</span>
        </a>

        <a class="carousel-control-next" href="#recipeCarousel" role="button" data-bs-slide="next" style="width: 40px; background: black">
          <span class="carousel-control-next-icon" aria-hidden="true"></span>
          <span class="visually-hidden">Proximo</span>
        </a>
      </div>
    </div>
  </div>


  @foreach ($produtos as $prod)
{{--     modal--}}
    <div class="modal fade modalProd" id="modalProdShow{{$prod->codigo}}" tabindex="-1" role="dialog" aria-labelledby="modalProdShow{{$prod->codigo}}" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
          <div class="modal-header text-right">
            <h5 class="text-center">{{$prod->descricao}}</h5>
          </div>
          <div class="modal-body">
            <div class="card">
              <div class="card-body">
                <div class="container">
                <center>
                  <div class="row  justify-content-center">
                    <div class="container-fluid">
                      <img class="img-fluid" src="{{asset($prod->caminho ?? '' )}}" width="450" height="130" alt="{{$prod->descricao}}">
                    </div>
                  </div>
                  <br>
                  <div class="container">
                    <h4 class="text-center">{{$prod->descricao}}</h4>
                  </div>
                </center>
                </div>
              </div>
            </div>
          </div>
          <div class="text-center mt-3 mb-3">
            <button type="button"class="btn btn-secondary col-md-2" data-dismiss="modal">Fechar</button>
            <button type="submit" class="btn btn-danger col-md-2" data-bs-target="#modalProdCotar{{$prod->codigo}}" data-bs-toggle="modal" data-bs-dismiss="modal">Cotar</button>
          </div>
      </div>
      </div>
    </div>
    <div class="modal fade" id="modalProdCotar{{$prod->codigo}}"  aria-hidden="true" aria-labelledby="modalProdCotar{{$prod->codigo}}"tabindex="-1">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-body">
            <div class="card">
              <form>
                <p></p>
                <div class="">
                  <div class="container">
                    <form id="contactForm" name="sentMessage" novalidate="novalidate" action="{{ route('mail.contato') }}" method="POST">
                      {{ csrf_field() }}
                      <h4 class="text-uppercase text-center text-dark">formulário de contato</h4>
                      <p></p>
                      <div class="row">
                        <div class="form-group col-6">
                          <label for="inputPassword4">Nome</label>
                          <input name="nome" class="form-control" id="nome" type="text" placeholder="Seu nome" required="required" data-validation-required-message="Por Favor preencha seu nome." />
                          <p class="help-block text-danger"></p>
                        </div>
                        <div class="form-group col-6">
                          <label for="inputPassword4">Telefone</label>
                          <input name="fone" class="form-control" id="tel" type="tel" placeholder="Ex: (xx) 9999-99999" required="required" data-validation-required-message="Por Favor Coloque seu Telefone." />
                          <p class="help-block text-danger"></p>
                        </div>
                      </div>
                      <div class="control-group">
                        <div class="form-group">
                          <label>E-mail</label>
                          <input name="email" class="form-control" id="email" type="email" placeholder="seu E-mail" required="required" data-validation-required-message="Por Favor preencha seu email." />
                          <p class="help-block text-danger"></p>
                        </div>
                      </div>
                      <div class="control-group">
                        <div class="form-group">
                          <label>Observações</label>
                          <textarea name="msg" class="form-control" id="message" rows="5" placeholder="Mensagem">{{$prod->codigo.'-'.$prod->descricao}}</textarea>
                        </div>
                      </div>
                      <div class="text-center mt-3">
                        <button class="btn btn-primary col-md-2 p " id="sendMessageButton" type="submit">Enviar</button>
                        <button type="button" class="btn btn-outline-secondary col-md-2"  data-bs-dismiss="modal">Fechar</button>
                      </div>
                    </form>
                  </div>
                </div>
                <p></p>
              </form>
              <p></p>
            </div>
          </div>
        </div>
      </div>
    </div>
  @endforeach
  <br>
</section>
@endif





