<!DOCTYPE html>
<html lang="pt-br">
<head>
  <title>Login</title>
  <!--Import Google Icon Font-->
  <link rel="stylesheet" type="text/css" href="{{ asset('styles/css/app.css') }}">
  <link rel="stylesheet" type="text/css" href="{{ asset('styles/css/login/styleLogin.css') }}" />
  {{-- Para impedir que somente os rastreadores da Web do Google indexe uma página: --}}
  <meta name="robots" content="noindex">
  <meta name="googlebot" content="noindex">
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
</head>
<body>
  <div class="login">
    <h1>Login</h1>
    <form class="form-contro" action="{{ route('admin.login.entrar') }}" method="POST" >
      @if ($errors->all())
        @foreach ($errors->all() as $error)
          <div class="alert alert-danger" role='alert'>
            {{$error}}
            {{-- vem de adminController@entrar --}}
          </div>
        @endforeach
      @endif
      {{ csrf_field() }}
      <input class="form-contro" type="email" name="email" placeholder="Email" required="required" />
      <input class="form-contro" type="password" name="senha" placeholder="Senha" required="required" />
      <button class="form-control btn btn-primary btn-large" type="submit">Entrar</button>
      <p class="text-center mb-3 mt-3 fw-bold mx-3 mb-0 text-muted">OU</p>
      <a  class="form-control btn btn-outline-secondary" href="{{ route('site.home') }}">Voltar</a>
    </form>
    </div>
<script src="{{ asset('styles/js/jquery.js') }}" defer></script>
<script src="{{ asset('styles/js/bootstrap.js')}}" defer></script>
</body>
</html>
