@extends('painel.template.Layout.padrao')
@section('titulo', 'Painel Dashboard')
@section('conteudo')
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-3 col-6">
          <!-- small box -->
          <div class="small-box bg-gradient-navy">
            <div class="inner">
              @foreach($visitor as $v)
                <h3>{{isset($v->Dvisitas) ? $v->Dvisitas : '0'}}</h3>
              @endforeach
                <p>Visitas de Hoje</p>
            </div>
            <div class="icon">
              <i class="ion ion-stats-bars"></i>
            </div>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <!-- small box -->
          <div class="small-box bg-gradient-navy">
            <div class="inner">
              @foreach($visitor as $v)
                <h3>{{isset($v->Wvisitas) ? $v->Wvisitas : '0'}}</h3>
              @endforeach
              <p>Visitas últimos 7 dias</p>
            </div>
            <div class="icon">
              <i class="ion ion-stats-bars"></i>
            </div>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <!-- small box -->
          <div class="small-box bg-gradient-navy">
            <div class="inner">
              @foreach($visitor as $v)
                <h3>{{isset($v->Mvisitas) ? $v->Mvisitas : '0'}}</h3>
              @endforeach
              <p>Visitas útimos 30 dias</p>
            </div>
            <div class="icon">
              <i class="ion ion-stats-bars"></i>
            </div>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <!-- small box -->
          <div class="small-box bg-gradient-navy">
            <div class="inner">
              @foreach($visitor as $v)
                <h3>{{isset($v->Yvisitas) ? $v->Yvisitas : '0'}}</h3>
              @endforeach
              <p>Total de Visitas</p>
            </div>
            <div class="icon">
              <i class="ion ion-stats-bars"></i>
            </div>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-lg-12">
          <div class="card">
            <div class="card-header border-0">
              <div class="d-flex justify-content-between">
                <h3 class="card-title">Estatísticas de visitas</h3>
              </div>
            </div>
            <div class="card-body">
              <div class="d-flex">
                <p class="d-flex flex-column">
                  @foreach($visitor as $v)
                    <span class="text-bold text-lg">{{ isset($v->Yvisitas) ? $v->Yvisitas : '0' }}</span>
                    <span>Total de Visitas Realizadas</span>
                  @endforeach
                </p>
              </div>
              <!-- /.d-flex -->

              <div class="position-relative mb-4">
                <canvas id="visitors-chart" height="350"></canvas>
              </div>

              <div class="d-flex flex-row justify-content-end">
                  <span class="mr-2">
                    <i class="fas fa-square text-primary"></i> Visitas realizadas separadas por mês
                  </span>
              </div>
            </div>
          </div>
          <!-- /.card -->
        </div>
       </div>
      <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
  </div>
@endsection
