@extends('painel.template.Layout.padrao')
@section('titulo', 'Painel Categoria')
@section('conteudo')
  <style type="text/css">
    .btnremove {
      margin-top: -180px;
      margin-left: 30px;
      width: 100px;
      height: 30px;
      padding: 0;
      border: 0 none;
      background: transparent;
      color: transparent;
    }

    .btnremove:hover {
      visibility: visible;
      filter: opacity(75%) !important;
    }
  </style>
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">
          <div class="card">
            <div class="card-header border-0">
              <div class="d-flex justify-content-between">

                @if(Route::is('admin.cadastrarCategoria'))
                  <h3 class="card-title">Cadastrar Categoria</h3>
                @else
                  <h3 class="card-title">Editar Categoria</h3>
                  @php
                    $cat = $categorias->first();
                  @endphp

                @endif
              </div>
            </div>
            <div class="card-body">
              <form id="formManCat" name="formManCat" novalidate="novalidate"
                    action="{{ route('admin.salvarCategoria') }}"
                    method="POST" enctype="multipart/form-data">
                <div class="card">
                  <div class="card-body">
                    {{ csrf_field() }}
                    <div class="row">
                      <label class="ml-3">Código</label>
                      <div class="col-sm-2 col-md-2">
                        @if(Route::is('admin.cadastrarCategoria'))
                          <input class="form-control form-control-sm" type="text" name="codigo"
                               value="{{isset($cat->codigo)  ? $cat->codigo : '' }}"/>
                        @else
                          <input class="form-control form-control-sm" type="text" name="codigo" disabled
                                 value="{{isset($cat->codigo)  ? $cat->codigo : '' }}"/>
                          <input type="hidden" name="codigo" value="{{isset($cat->codigo)  ? $cat->codigo : '' }}"/>
                        @endif
                      </div>
                      <label class="ml-3">Descrição</label>
                      <div class="col-sm">
                        <input class="form-control form-control-sm" type="text" name="descricao"
                               value="{{$cat->descricao  ?? '' }}">
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row justify-content-center">
                  <button type="button" align="center" class="btn btn-secondary"
                          onclick="location.href = '{{route('admin.categorias')}}'">Fechar
                  </button>
                  <button type="submit" class="btn btn-success" id="btnModal" align="center">Salvar</button>
                </div>
              </form>
            </div>

          </div>
          <!-- /.card -->
        </div>
      </div>
      <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
  </div>
@endsection


