@extends('painel.template.Layout.padrao')
@section('titulo', 'Painel Produtos')
@section('conteudo')
  <style type="text/css">
    .btnremove {
      margin-top: -180px;
      margin-left: 30px;
      width: 100px;
      height: 30px;
      padding: 0;
      border: 0 none;
      background: transparent;
      color: transparent;
    }

    .btnremove:hover {
      visibility: visible;
      filter: opacity(75%) !important;
    }
  </style>
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">
          <div class="card">
            <div class="card-header border-0">
              <div class="d-flex justify-content-between">

                @if(Route::is('admin.manProdutos'))
                  <h3 class="card-title">Editar Subgrupos</h3>
                  @php
                    $subgr = $subgrupo->first();
                  @endphp
                @else
                  <h3 class="card-title">Cadastrar Subgrupo</h3>
                @endif
              </div>
            </div>
            <div class="card-body">
              <form id="formManProd" name="formManProd" novalidate="novalidate"
                    action="{{ route('admin.salvarSubgrupo') }}"
                    method="POST" enctype="multipart/form-data">
                <div class="card">
                  <div class="card-body">
                    {{ csrf_field() }}
                    <div class="row">
                      <label class="ml-3">Código</label>
                      <div class="col-sm-2 col-md-2">
                        <input class="form-control form-control-sm" type="text" name="codigo" value="{{isset($subgr->codigo)  ? $subgr->codigo : '' }}"/>
                      </div>
                      <label class="ml-3">Descrição</label>
                      <div class="col-sm">
                        <input class="form-control form-control-sm" type="text" name="descricao"
                               value="{{$subgr->descricao  ?? '' }}">
                      </div>
                    </div>
                    <div class="row mt-2">
                      <label class="ml-3">%Margem Padrão</label>
                      <div class="col-sm-2 col-md-2">
                        <input class="form-control form-control-sm" type="text" name="codigo" value="{{isset($subgr->codigo)  ? $subgr->codigo : '' }}"/>
                      </div>
                      <label class="ml-3">% Comissão</label>
                      <div class="col-sm-2 col-md-2">
                        <input class="form-control form-control-sm" type="text" name="percomis"
                               value="{{$subgr->percomis  ?? '' }}">
                      </div>
                      <label class="ml-3">Não Comissionado</label>
                      <div class="col">
                        @if(Route::is('admin.manProdutos'))
                          @if ($subgr->naocomis == 1)
                            <input class="form-control-sm" type="checkbox" name="naocomis" checked>
                          @else
                            <input class="form-control-sm" type="checkbox" name="naocomis">
                          @endif
                        @else
                          <input class="form-control-sm" type="checkbox" name="naocomis">
                        @endif
                      </div>
                    </div>
                    <div class="row mt-2">
                      <div class="col">

                        <div class="dropdown">
                          <label>Grupo</label>
                            <a class="btn btn-group-sm btn-secondary dropdown-toggle form-control-sm" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="min-width: 80%">

                            </a>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuLink" style="min-width: 80%">
                            <a class="dropdown-item" href="#">grupo 1</a>
                            <a class="dropdown-item" href="#">grupo 2</a>
                            <a class="dropdown-item" href="#">grupo 3</a>
                            <a class="dropdown-item" href="#">grupo 4</a>
                            <a class="dropdown-item" href="#">grupo 5</a>

                          </div>
                        </div>
                      </div>
                      <label class="ml-3">NCM/SH</label>
                      <div class="col-sm-2 col-md-2">
                        <input class="form-control form-control-sm" type="text" name="codigo" value="{{isset($subgr->codigo)  ? $subgr->codigo : '' }}"/>
                      </div>
                    </div>
                    <div class="row mt-2">
                      <div class="container">
                        <div class="card">
                          <div class="row m-2">
                            <label class="ml-3">Largura</label>
                            <div class="col-sm">
                              <input class="form-control form-control-sm" type="text" name="codigo" value="{{isset($subgr->codigo)  ? $subgr->codigo : '' }}"/>
                            </div>

                            <label class="ml-3">Altura</label>
                            <div class="col-sm">
                              <input class="form-control form-control-sm" type="text" name="percomis"
                                     value="{{$subgr->percomis  ?? '' }}">
                            </div>

                            <label class="ml-3">Profundidade</label>
                            <div class="col-sm">
                              <input class="form-control form-control-sm" type="text" name="percomis"
                                     value="{{$subgr->percomis  ?? '' }}">
                            </div>
                          </div>
                        </div>
                      </div>

                    </div>
                  </div>

                </div>
                <div class="row justify-content-center">
                  <button type="button" align="center" class="btn btn-secondary"
                          onclick="location.href = '{{route('admin.produtos')}}'">Fechar
                  </button>
                  <button type="submit" class="btn btn-success" id="btnModal" align="center">Salvar</button>
                </div>
              </form>
            </div>

          </div>
          <!-- /.card -->
        </div>
      </div>
      <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
  </div>
@endsection


