<?php

use Illuminate\Support\Facades\Route;

//Route::group(array('domain' => 'xx.127.0.0.1:8000'), function(){

Route::group(['middleware'=>'multtenant'],function (){

  Route::get('/vue-teste', function () {return view('vue-teste');});


	Route::get('/', 'Home\HomeController@index')->name('site.home');
	Route::get('/home', 'Home\HomeController@index')->name('home.home');
  Route::get('/produto/{slug}', 	'Home\ProductsController@findProducts')->name('home.detalhes');
	Route::post('/email-contato', 'Home\HomeController@mail')->name('mail.contato');

  Route::get('/card', 'Home\CardController@show')->name('home.card');

  Route::get('/card/upitens', function () {return redirect('/card');});//para nao entrar na pagina de add e explodi
  Route::post('/card/upitens', 'Home\CardController@setCookie')->name('home.card.upitens');

  Route::get('/finishing/endereco', 'Home\EntregaController@show')->name('home.finishing.entrega');
  Route::post('/finishing/pag', 'Home\CardController@entrega')->name('home.finishing.pag');

  //Route::get('/card/limpa', function () {return redirect('/card');});//para nao entrar na pagina de limpar e explodi
  Route::get('/card/limpa', 'Home\CardController@cookieMata')->name('home.card.limpa');

  //routes admin "publicas"
	Route::get('/admin', 'Painel\AdminController@login')->name('admin.login');
	Route::post('/admin/login', 'Painel\AdminController@entrar')->name('admin.login.entrar');
	Route::get('/admin/logout', 'Painel\AdminController@sair')->name('admin.login.sair');


	Route::group(['middleware'=>'auth'],function (){
    //rotas geral admin
    //Route::get('/temp',                       'Home\HomeController@index2')->name('site.template');
    Route::get('/admin/dashboard',	          'Painel\AdminController@visitor')->name('admin.dashboard');
    //Route::get('/dashboard',	                'Admin\AdminController@dashboard')->name('admin.dashboard');
		Route::post('/admin/update',					  	'Painel\ConfigController@update')->name('admin.update');
		//rotas banner
    Route::get('/admin/banners', 				    	'Painel\BannerController@show')->name('admin.banner');
		Route::post('/admin/addbanner', 					'Painel\BannerController@addBanner')->name('admin.addBanner');
		Route::get('/admin/delete/banner/{id}', 	'Painel\BannerController@deleteBanner')->name('admin.deleteBanner');
		//rotas fotos da empresa/galeria
		Route::post('/admin/addfoto', 						'Painel\FotoEmpresaController@addFotoEmpresa')->name('admin.addFotoEmpresa');
		Route::get('/admin/delete/fotoemp/{id}', 	'Painel\FotoEmpresaController@deleteFotoEmp')->name('admin.deleteFotoEmp');
    //tratamentos e exclusoes de fotos
    Route::group(['prefix' => '/admin/fotos'], function () {
      Route::get('/del', 	'Painel\FotosController@deleteFoto')->name('admin.deleteFoto');
    });
		//rotas produtos
    Route::group(['prefix' => '/admin/produtos'], function () {
      Route::get('/', 					            'Painel\ProdutoController@show')->name('admin.produtos');
      Route::get('/search', 					      'Painel\ProdutoController@search')->name('admin.searchProd');
      Route::get('/cadastrar', 				  	  'Painel\ProdutoController@add')->name('admin.addProdutos');
      Route::get('/editar/{id}', 					  'Painel\ProdutoController@edit')->name('admin.manProdutos');
      Route::post('/save',    					    'Painel\ProdutoController@save')->name('admin.saveprod');
      Route::get('/delete/{id}', 	          'Painel\ProdutoController@delete')->name('admin.deleteProd');
    });
    //rotas subgrupos
    Route::group(['prefix' => '/admin/subgrupo'], function () {
      Route::get('/', 					            'Painel\SubgrupoController@show')->name('admin.subgrupos');
      Route::get('/search', 					      'Painel\SubgrupoController@search')->name('admin.pesqSubgrupo');
      Route::get('/cadastrar', 				  	  'Painel\SubgrupoController@add')->name('admin.cadastrarSubgrupo');
      Route::get('/editar/{id}', 					  'Painel\SubgrupoController@edit')->name('admin.manSubgrupo');
      Route::post('/save',    					    'Painel\SubgrupoController@save')->name('admin.salvarSubgrupo');
      Route::get('/delete/{id}', 	          'Painel\SubgrupoController@delete')->name('admin.deleteSubgrupo');
    });
    //rotas Grupos
    Route::group(['prefix' => '/admin/grupo'], function () {
      Route::get('/', 					            'Painel\GrupoproController@show')->name('admin.grupos');
      Route::get('/search', 					      'Painel\GrupoproController@search')->name('admin.pesqGrupo');
      Route::get('/cadastrar', 				  	  'Painel\GrupoproController@add')->name('admin.cadastrarGrupo');
      Route::get('/editar/{id}', 					  'Painel\GrupoproController@edit')->name('admin.manGrupo');
      Route::post('/save',    					    'Painel\GrupoproController@save')->name('admin.salvarGrupo');
      Route::get('/delete/{id}', 	          'Painel\GrupoproController@delete')->name('admin.deleteGrupo');
    });
    //rotas Departamentos
    Route::group(['prefix' => '/admin/departamento'], function () {
      Route::get('/', 					            'Painel\DeptoproController@show')->name('admin.departamentos');
      Route::get('/search', 					      'Painel\DeptoproController@search')->name('admin.pesqDepto');
      Route::get('/cadastrar', 				  	  'Painel\DeptoproController@add')->name('admin.cadastrarDepto');
      Route::get('/editar/{id}', 					  'Painel\DeptoproController@edit')->name('admin.manDepto');
      Route::post('/save',    					    'Painel\DeptoproController@save')->name('admin.salvarDepto');
      Route::get('/delete/{id}', 	          'Painel\DeptoproController@delete')->name('admin.deleteDepto');
    });
    //rotas Marcas
    Route::group(['prefix' => '/admin/marcas'], function () {
      Route::get('/', 					            'Painel\MarcaproController@show')->name('admin.marcas');
      Route::get('/search', 					      'Painel\MarcaproController@search')->name('admin.pesqMarca');
      Route::get('/cadastrar', 				  	  'Painel\MarcaproController@add')->name('admin.cadastrarMarca');
      Route::get('/editar/{id}', 					  'Painel\MarcaproController@edit')->name('admin.manMarca');
      Route::post('/save',    					    'Painel\MarcaproController@save')->name('admin.salvarMarca');
      Route::get('/delete/{id}', 	          'Painel\MarcaproController@delete')->name('admin.deleteMarca');
    });
    //rotas Categorias
    Route::group(['prefix' => '/admin/categorias'], function () {
      Route::get('/', 					            'Painel\CategoriaController@show')->name('admin.categorias');
      Route::get('/search', 					      'Painel\CategoriaController@search')->name('admin.pesqCategoria');
      Route::get('/cadastrar', 				  	  'Painel\CategoriaController@add')->name('admin.cadastrarCategoria');
      Route::get('/editar/{id}', 					  'Painel\CategoriaController@edit')->name('admin.manCategoria');
      Route::post('/save',    					    'Painel\CategoriaController@save')->name('admin.salvarCategoria');
      Route::get('/delete/{id}', 	          'Painel\CategoriaController@delete')->name('admin.deleteCategoria');
    });
    //rotas configuracoes
    Route::get('/admin/config', 					  'Painel\AdminController@show')->name('admin.config');
		Route::get('/testes', function () { return view('painel.teste');});

    //rotas graficos
    Route::get('/admin/get-graph', 					  'Painel\getDadosGraphController@sumVisitorMonth')->name('admin.graph');
    //rotas usuarios
    Route::post('/admin/addUser', 	  				  'Painel\AdminController@addUser')->name('admin.addUser');
    Route::get('/admin/usuarios', 					  'Painel\AdminController@showUser')->name('admin.showUser');
    Route::post('/admin/update/user', 				'Painel\AdminController@updateUser')->name('admin.updateUser');
    Route::get('/admin/delete/user/{id}', 	  'Painel\AdminController@deleteUser')->name('admin.deleteUser');
	});
});

