<?php
  $search = isset($_GET['search']) ? $_GET['search'] : $_GET['search']= '';
  $nProd = $produtos->count();

?>
<div class="card prodcard">
  <div class="card-body">
    <form action="<?php echo e(route('admin.searchProd')); ?>" method="get">
      <?php echo e(csrf_field()); ?>

      <div class="input-group mb-sm-3">
        <input type="text" class="form-control" name="search" placeholder="Ex: produto" value="<?php echo e($search); ?>">
        <div class="input-group-append">
          <button class="btn btn-outline-secondary" type="submit">Pesquisar</button>
        </div>
        <div class="input-group-append">
          <button class="btn btn-outline-secondary" type="button"
                  onclick="location.href = '<?php echo e(route('admin.addProdutos')); ?>'">Cadastrar
          </button>
        </div>
      </div>
    </form>
    <table class="table table-sm table-hover ">
      <thead>
      <tr class="row small">
        <th class="col-xs-2 col-sm-2 col-md-2 col-lg-2">Código</th>
        <th class="col-xs-7 col-sm-7 col-md-7 col-lg-4">Descrição</th>
        <th class="col-xs-2 col-sm-2 col-md-2 col-lg-2">Preço</th>
        <th class="text-center col-xs-3 col-sm-3 col-md-3 col-lg-4">Ação</th>
      </tr>
      </thead>
      <tbody>
      <?php $__currentLoopData = $produtos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <tr class="row">
          <td class="col-xs-2 col-sm-2 col-md-2 col-lg-2"><?php echo e($prod->codigo); ?></td>
          <td class="col-xs-5 col-sm-5 col-md-5 col-lg-4"><?php echo e($prod->descricao); ?></td>
          <td class="col-xs-2 col-sm-2 col-md-2 col-lg-2"><?php echo e(formataValor($prod->precoeco, 13,3)); ?></td>
          <td class="text-center col-xs-3 col-sm-3 col-md-3 col-lg-4">
            
            <button class="btn btn-sm btn-outline-success col-lg-4 col-md-6 col-sm-12" type="submit"
                    onclick="location.href = '<?php echo e(route('admin.manProdutos',$prod->codigo)); ?>'">Editar
            </button>
            
            
            
            <button class="btn btn-sm btn-outline-danger col-lg-4 col-md-6 col-sm-12" type="button" data-toggle="modal"
                    data-target="#modalDel<?php echo e($prod->codigo); ?>">Deletar
            </button>
          </td>
        </tr>
        
        <div class="modal fade" id="modalDel<?php echo e($prod->codigo); ?>" tabindex="-1" role="dialog"
             aria-labelledby="modalDel.<?php echo e($prod->codigo); ?>" aria-hidden="true">
          <div class="modal-dialog modal-dialog" role="document">
            <div class="modal-content">
              <div class="modal-header text-right">
                <h5 class="text-center">Deseja realmente excluir este produto?</h5>
              </div>
              <div class=" modal-footer align-content-center">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                <button type="button" class="btn btn-danger"
                        onclick="location.href = '<?php echo e(route('admin.deleteProd',$prod->codigo  )); ?>'">Excluir
                </button>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </tbody>
    </table>
    <div class="container  pagprod">
      <div class="row justify-content-sm-center">
        <?php echo e($produtos->links()); ?>

      </div>

    </div>
  </div>
</div>

<?php /**PATH C:\projects\lara\projectwix\resources\views/painel/_includes/_produtos/listaProdutos.blade.php ENDPATH**/ ?>